//////////////////////////////////////////////////////////////////////////////
//
//  Copyright 2017 Autodesk, Inc.  All rights reserved.
//
//  Use of this software is subject to the terms of the Autodesk license 
//  agreement provided at the time of installation or download, or which 
//  otherwise accompanies this software in either electronic or hard copy form.   
//
//////////////////////////////////////////////////////////////////////////////

#include "MAXtoATestModifier.h"

// arnold
#undef min
#undef max
#include <ai.h>

#include <ai_nodes.h>

#include "../../include/3dsmax_banned.h"

class MAXtoATestModifier_ClassDesc : public ClassDesc2 
{
public:
    virtual int IsPublic() { return TRUE; }
    virtual void* Create(BOOL /*loading = FALSE*/) { return new MAXtoATestModifier(); }
    virtual const TCHAR *	ClassName() { return _T("MAXtoATestModifier");}
    virtual SClass_ID SuperClassID() { return OSM_CLASS_ID; }
    virtual Class_ID ClassID() { return MAXtoATestModifier_CLASS_ID; }
    virtual const TCHAR* Category() { return _T("MAXtoATest"); }

    virtual const TCHAR* InternalName() { return _T("MAXtoATestModifier"); }	// returns fixed parsable name (scripter-visible name)
    virtual HINSTANCE HInstance();
};

HINSTANCE MAXtoATestModifier_ClassDesc::HInstance() 
{
    extern HINSTANCE hInstance;
    return hInstance;
}

Arnold_translation::TranslationInterface_Result MAXtoATestModifier_translationInterface::Translate(INode* node,
    Arnold_translation* arnold_translation,
    const TimeValue translationTime,
    Interval& newValidity)
{
    Arnold_translation::TranslationInterface_Result res = Arnold_translation::Success;

    AtNode* aNode = arnold_translation->GetOutput(0, AtString("sphere"), AtString("MyMAXtoATestSphere"));
    AiNodeSetFlt(aNode, AtString("radius"), 2.f);

    int skip = Arnold_translation::SkipFlag_Transform;
    res = arnold_translation->PerformGenericTranslation(0, skip);

    return res;
}

MAXtoATestModifier_translationInterface::MAXtoATestModifier_translationInterface(MAXtoATestModifier* mod)
    : m_mod(mod)
{
}

MAXtoATestModifier::MAXtoATestModifier()
    : m_ti(this)
{
}

MAXtoATestModifier::~MAXtoATestModifier()
{
}

void MAXtoATestModifier::ModifyObject(TimeValue /*t*/, ModContext& /*mc*/, ObjectState* /*os*/, INode* /*node*/)
{
}

RefResult MAXtoATestModifier::NotifyRefChanged(
    const Interval& /*changeInt*/, RefTargetHandle /*hTarget*/,
    PartID& /*partID*/, RefMessage message, BOOL /*propagate*/)
{
    return REF_SUCCEED;
}

void MAXtoATestModifier::NotifyInputChanged(const Interval &/*changeInt*/, PartID /*partID*/, RefMessage /*message*/, ModContext* /*mc*/)
{
}

void MAXtoATestModifier::GetClassName(TSTR& s)
{
    s = _T("MAXtoATestModifier");
}

void* MAXtoATestModifier::GetInterface(ULONG id)
{
    return Modifier::GetInterface(id);
}

BaseInterface* MAXtoATestModifier::GetInterface(Interface_ID id)
{
    if (id == MAXTOA_TranslationInterface_ID)
        return &(this->m_ti);

    return Modifier::GetInterface(id);
}

ClassDesc2& MAXtoATestModifier::GetClassDesc() 
{
    static MAXtoATestModifier_ClassDesc classDesc;
    return classDesc;
}
